use std::{fmt,ops,cmp::Ordering};
use crate::build_in::LibFunc;
#[derive(PartialEq,Clone,Debug)]
pub enum Value{
    Int(i128),
    String(String),
    Nil,
    Float(f64),
    Bool(u8),
    BuildInFunc(LibFunc),
}
impl fmt::Display for Value{
    fn fmt(&self, f: &mut fmt::Formatter<'_>)->fmt::Result{
        match self{
            Value::Int(x)=>write!(f,"{}",x),
            Value::String(x)=>write!(f,"{}",x),
            Value::Nil=>write!(f,"nil"),
            Value::Float(x)=>write!(f,"{}",x),
            Value::Bool(0)=>write!(f,"false"),
            Value::Bool(1)=>write!(f,"true"),
            Value::Bool(x)=>write!(f,"{}",x),
            Value::BuildInFunc(_)=>write!(f,"<Bulid-In-Function>"),
        }
    }
}
impl ops::Add for Value{
    type Output=Result<Self,String>;
    fn add(self,rhs:Self)->Self::Output{
        match (self,rhs){
            (Value::Nil,Value::Nil)=>Ok(Value::Nil),
            (Value::Bool(x),Value::Bool(y))=>Ok(Value::Bool(x+y)),
            (Value::Int(a),Value::Int(b))=>Ok(Value::Int(a+b)),
            (Value::Float(a),Value::Float(b))=>Ok(Value::Float(a+b)),
            (Value::String(a),Value::String(b))=>Ok(Value::String(a+&b)),
            //other
            _=>Err("Two value cannot add".to_string()),
        }
    }
}
impl ops::Sub for Value{
    type Output=Result<Self,String>;
    fn sub(self,rhs:Self)->Self::Output{
        match (self,rhs){
            (Value::Nil,Value::Nil)=>Ok(Value::Nil),
            (Value::Int(a),Value::Int(b))=>Ok(Value::Int(a-b)),
            (Value::Float(a),Value::Float(b))=>Ok(Value::Float(a-b)),
            (Value::Bool(x),Value::Bool(y))=>Ok(Value::Bool(x-y)),
            //other
            _=>Err("Two value cannot sub".to_string()),
        }
    }
}
impl ops::Mul for Value{
    type Output=Result<Self,String>;
    fn mul(self,rhs:Self)->Self::Output{
        match (self,rhs){
            (Value::Nil,Value::Nil)=>Ok(Value::Nil),
            (Value::Int(a),Value::Int(b))=>Ok(Value::Int(a*b)),
            (Value::Float(a),Value::Float(b))=>Ok(Value::Float(a*b)),
            (Value::Bool(x),Value::Bool(y))=>Ok(Value::Bool(x*y)),
            //other
            _=>Err("Two value cannot mul".to_string()),
        }
    }
}
impl ops::Div for Value{
    type Output=Result<Self,String>;
    fn div(self,rhs:Self)->Self::Output{
        match (self,rhs){
            (Value::Nil,Value::Nil)=>Ok(Value::Nil),
            (Value::Int(a),Value::Int(b))=>Ok(Value::Int(a/b)),
            (Value::Float(a),Value::Float(b))=>Ok(Value::Float(a/b)),
            (Value::Bool(x),Value::Bool(y))=>Ok(Value::Bool(x/y)),
            //other
            _=>Err("Two value cannot div".to_string()),
        }
    }
}
impl ops::Not for Value{
    type Output=Result<Self,String>;
    fn not(self)->Self::Output{
        match self{
            Value::Bool(0)=>Ok(Value::Bool(1)),
            Value::Bool(1)=>Ok(Value::Bool(0)),
            Value::Nil=>Ok(Value::Bool(1)),
            _=>Err("This value cannot reverse".to_string()),
        }
    }
}
impl PartialOrd for Value{
    fn partial_cmp(&self,other:&Self)->Option<Ordering>{
        match (self,other){
            (Value::Int(x),Value::Int(y))=>Some(x.cmp(y)),
            (Value::Float(x),Value::Float(y))=>{
                if *x<*y{Some(Ordering::Less)}
                else if *x>*y{Some(Ordering::Greater)}
                else{Some(Ordering::Equal)}
            }
            _=>None,
        }
    }
}
impl Value{
    pub fn pow(self,rhs:Self)->Result<Self,String>{
        if let (Value::Int(x),Value::Int(y))=(self,rhs){
            Ok(Value::Int(x.pow(y as u32)))
        }else{Err("Two value cannot pow".to_string())}
    }
}